/*
*  Object %name    : %
*  State           :  %state%
*  Creation date   :  Wen Mar 14 10:17:10 2007
*  Last modified   :  %modify_time%
*/
/** @file 
*  \brief A brief description of this module 
*
*  \version CE2_TST_AES.c#1:csrc:1
*  \author Yermalayeu Ihar
*  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************* Include Files ****************/

#include <memory.h>
#include "CryptoEngine2.h"
#include "CE2_TST_AES.h"
#include "CE2_TST_Common.h"

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs ******************************/
/************************ Global Data ***************************/
DxUint8_t CE2_TST_Utils_Num1[] = {
  0x01, 0x02, 0x03, 0x04
};

DxUint8_t CE2_TST_Utils_Num2[] = {
  0x05, 0x06, 0x07, 0x08
};

DxUint8_t CE2_TST_Utils_Res[] = {
  0x05, 0x10, 0x22, 0x3C, 0x3D, 0x34, 0x20
};

DxUint32_t CE2_TST_Utils_Num1SizeInBits = 25;
DxUint32_t CE2_TST_Utils_Num2SizeInBits = 27;
DxUint32_t CE2_TST_Utils_ResSizeInBits = 51;

/************************ Public Functions ******************************/

/*****************************************************************************
* Function Name:                                                           
* 	CE2_TST_Utils_MulNum 		
* 
* Inputs:
* 	None
*
* Outputs:
* 	CE2Error_t - Function error return		    					  		
*
* Description:																	
* 	This function verify function CE2_MulNum							
* Algorithm:		
*  -#
******************************************************************************/	
CE2Error_t CE2_TST_Utils_MulNum(FILE* out)
{
  CE2Error_t result = CE2_OK, error;
  DxUint8_t CE2_TST_Utils_Out[sizeof(CE2_TST_Utils_Res)];
  DxUint32_t size;

  PrintTestBeginMsg(out, __FUNCTION__);

  error = CE2_MulNum((DxUint32_t*)CE2_TST_Utils_Num1, CE2_TST_Utils_Num1SizeInBits,
    (DxUint32_t*)CE2_TST_Utils_Num2, CE2_TST_Utils_Num2SizeInBits,
    (DxUint32_t*)CE2_TST_Utils_Out, &size);
  if (error != CE2_OK) {
    fprintf(out, "Can't make CE2_MulNum!");
    result |= error;
    goto test_end;
  }

  if (memcmp(CE2_TST_Utils_Out, CE2_TST_Utils_Res, sizeof(CE2_TST_Utils_Res)) != 0) {
    fprintf(out, "Wrong CE2_MulNum output!\n");
    PrintBuffer(stdout, CE2_TST_Utils_Out, sizeof(CE2_TST_Utils_Res), "\nOutput:");
    PrintBuffer(stdout, CE2_TST_Utils_Res, sizeof(CE2_TST_Utils_Res), "\nControl:");
    result |= CE2_TST_FAILED;
    goto test_end;
  }

test_end:
  PrintTestEndMsg(out, __FUNCTION__, result);

  return result;
}

/*****************************************************************************
* Function Name:                                                           
* 	CE2_TST_Utils_GetBufferEffectiveSizeInBits 		
* 
* Inputs:
* 	None
*
* Outputs:
* 	CE2Error_t - Function error return		    					  		
*
* Description:																	
* 	This function verify function CE2_GetBufferEffectiveSizeInBits							
* Algorithm:		
*  -#
******************************************************************************/	
CE2Error_t CE2_TST_Utils_GetBufferEffectiveSizeInBits(FILE* out)
{
  CE2Error_t result = CE2_OK, error;
  DxUint32_t size;

  PrintTestBeginMsg(out, __FUNCTION__);

  error = CE2_GetBufferEffectiveSizeInBits(CE2_TST_Utils_Res, 
    sizeof(CE2_TST_Utils_Res), &size);
  if (error != CE2_OK) {
    fprintf(out, "Can't make CE2_GetBufferEffectiveSizeInBits!");
    result |= error;
    goto test_end;
  }

  if (size != CE2_TST_Utils_ResSizeInBits) {
    fprintf(out, "Wrong CE2_GetBufferEffectiveSizeInBits output!\n");
    result |= CE2_TST_FAILED;
    goto test_end;
  }


test_end:
  PrintTestEndMsg(out, __FUNCTION__, result);

  return result;
}
